/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import noppes.npcs.CustomNpcs;
import noppes.npcs.LogWriter;
import noppes.npcs.ModelPartData;
import noppes.npcs.client.EntityUtil;
import noppes.npcs.client.model.part.ModelData;
import noppes.npcs.constants.EnumParts;
import noppes.npcs.entity.EntityNPCFlying;
import noppes.npcs.entity.EntityNPCInterface;

public class EntityCustomNpc
extends EntityNPCFlying {
    public ModelData modelData = new ModelData();

    public EntityCustomNpc(World world) {
        super(world);
        if (!CustomNpcs.EnableDefaultEyes) {
            this.modelData.eyes.type = (byte)-1;
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.func_70613_aW()) {
            EntityLivingBase entity;
            ModelPartData particles = this.modelData.getPartData(EnumParts.PARTICLES);
            if (particles != null && !this.isKilled()) {
                CustomNpcs.proxy.spawnParticle((EntityLivingBase)this, "ModelData", this.modelData, particles);
            }
            if ((entity = this.modelData.getEntity(this)) != null) {
                try {
                    entity.func_70071_h_();
                }
                catch (Exception e) {
                    LogWriter.error(e);
                }
                EntityUtil.Copy((EntityLivingBase)this, entity);
            }
        }
        this.modelData.eyes.update(this);
    }

    @Override
    public void func_70037_a(@Nonnull NBTTagCompound compound) {
        if (compound.func_74764_b("NpcModelData")) {
            this.modelData.load(compound.func_74775_l("NpcModelData"));
        }
        super.func_70037_a(compound);
    }

    public boolean func_184205_a(@Nonnull Entity par1Entity, boolean force) {
        boolean b = super.func_184205_a(par1Entity, force);
        this.updateHitbox();
        return b;
    }

    @Override
    public void updateHitbox() {
        EntityLivingBase entity = this.modelData.getEntity(this);
        if (this.modelData == null || entity == null) {
            if (this.modelData != null) {
                this.baseWidth = 0.6f - this.modelData.getBodyX() + (Math.max(this.modelData.getPartConfig((EnumParts)EnumParts.HEAD).scale[0], this.modelData.getPartConfig((EnumParts)EnumParts.HEAD).scale[2]) - 1.0f) / 2.0f;
                this.baseHeight = 1.9f - this.modelData.getBodyY() + (this.modelData.getPartConfig((EnumParts)EnumParts.HEAD).scale[1] - 1.0f) / 2.0f;
            }
            super.updateHitbox();
        } else {
            if (entity instanceof EntityNPCInterface) {
                ((EntityNPCInterface)entity).updateHitbox();
            }
            this.field_70130_N = Math.max(0.1f, entity.field_70130_N / 5.0f * (float)this.display.getSize());
            this.field_70131_O = Math.max(0.1f, entity.field_70131_O / 5.0f * (float)this.display.getSize());
            this.eyeHeight = Math.max(0.1f, entity.func_70047_e() / 5.0f * (float)this.display.getSize());
            double n = this.field_70130_N / 2.0f;
            if (n > World.MAX_ENTITY_RADIUS) {
                World.MAX_ENTITY_RADIUS = this.field_70130_N / 2.0f;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    @Override
    public void func_70014_b(@Nonnull NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74782_a("NpcModelData", (NBTBase)this.modelData.save());
    }

    public boolean func_184198_c(@Nonnull NBTTagCompound compound) {
        boolean bo = super.func_184198_c(compound);
        if (bo) {
            String s = this.func_70022_Q();
            assert (s != null);
            if (s.equals("minecraft:customnpcs.customnpc") || s.equals("minecraft:customnpcs:customnpc")) {
                compound.func_74778_a("id", "customnpcs:customnpc");
            }
        }
        return bo;
    }

    public boolean func_70039_c(@Nonnull NBTTagCompound compound) {
        boolean bo = super.func_184198_c(compound);
        if (bo) {
            String s = this.func_70022_Q();
            assert (s != null);
            if (s.equals("minecraft:customnpcs.customnpc") || s.equals("minecraft:customnpcs:customnpc")) {
                compound.func_74778_a("id", "customnpcs:customnpc");
            }
        }
        return bo;
    }
}

